/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.client.render;

import com.kyanite.deeperdarker.content.DDEntities;
import com.kyanite.deeperdarker.content.blocks.CrystallizedAmberBlock;
import com.kyanite.deeperdarker.content.blocks.entity.CrystallizedAmberBlockEntity;
import com.kyanite.deeperdarker.content.entities.SculkLeech;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class CrystallizedAmberBlockRenderer
implements BlockEntityRenderer<CrystallizedAmberBlockEntity> {
    private final EntityRenderDispatcher entityRenderer;
    private final ItemRenderer itemRenderer;

    public CrystallizedAmberBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.getEntityRenderer();
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(CrystallizedAmberBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!((Boolean)blockEntity.getBlockState().getValue((Property)CrystallizedAmberBlock.FOSSILIZED)).booleanValue()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        RandomSource random = RandomSource.create((long)blockEntity.getBlockPos().asLong());
        random.nextFloat();
        poseStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 180.0f - 90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 180.0f));
        if (blockEntity.fossilizedEntity) {
            poseStack.scale(0.9f, 0.9f, 0.9f);
            SculkLeech leech = new SculkLeech((EntityType<? extends Monster>)((EntityType)DDEntities.SCULK_LEECH.get()), blockEntity.getLevel());
            this.entityRenderer.render((Entity)leech, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, bufferSource, packedLight);
        } else {
            poseStack.scale(0.6f, 0.6f, 0.6f);
            this.itemRenderer.renderStatic(blockEntity.getLoot(), ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
        }
        poseStack.popPose();
    }
}

